/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class InstanceContext {
    private static final Logger log = LoggerFactory.getLogger(InstanceContext.class);
    private static Cache<String, Object> sharedCache;

    public static synchronized Cache<String, Object> getInstanceCache() {
        if (sharedCache == null) {
            log.info("Created InstanceContext");
            sharedCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(100L).build();
        }
        return sharedCache;
    }

    public static void clear() {
        log.info("Cleared InstanceContext");
        if (sharedCache != null) {
            sharedCache.invalidateAll();
            sharedCache.cleanUp();
        }
    }
}

