/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gae.admin;

import java.util.HashSet;
import java.util.Set;
import org.xydra.gae.admin.GaeConfiguration;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class GaeConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(GaeConfigurationManager.class);
    private static GaeConfiguration currentConf = null;
    private static final long INITIAL_LIFETIME = 39600000L;
    private static GaeConfiguration defaultConfiguration = GaeConfiguration.createWithLifetime(39600000L);
    private static transient Set<Listener> listeners = new HashSet<Listener>();

    public static GaeConfiguration getDefaultConfiguration() {
        defaultConfiguration.setLifetime(39600000L);
        assert (defaultConfiguration.isStillValid());
        return defaultConfiguration;
    }

    public static synchronized GaeConfiguration getCurrentConfiguration() {
        if (currentConf == null) {
            log.info("Current config is null. Getting one.");
            currentConf = GaeConfigurationManager.loadConfigOrUseDefaults();
            GaeConfigurationManager.fireOnChange(currentConf);
        } else if (!currentConf.isStillValid()) {
            log.info("Current config is too old. Getting a fresh one.");
            currentConf = GaeConfigurationManager.loadConfigOrUseDefaults();
            GaeConfigurationManager.fireOnChange(currentConf);
        }
        assert (currentConf.isStillValid()) : "freshly loaded config is out of date";
        return currentConf;
    }

    public static synchronized GaeConfiguration loadConfigOrUseDefaults() {
        GaeConfiguration conf = GaeConfiguration.load();
        if (conf == null) {
            log.info("No configuration found in backend. Using defaults and writing them to backend");
            conf = GaeConfigurationManager.getDefaultConfiguration();
            conf.store();
        } else {
            log.info("Loaded config from backend.");
            if (!conf.isStillValid()) {
                log.info("Config was no longer valid. Extending lifetime for 1 minute. Persisting that.");
                conf.setLifetime(39600000L);
                conf.store();
            }
        }
        assert (conf != null);
        assert (conf.isStillValid());
        return conf;
    }

    public static void assertValidGaeConfiguration() {
        GaeConfigurationManager.getCurrentConfiguration();
    }

    public static void addListener(Listener listener) {
        listeners.add(listener);
    }

    public static void fireOnChange(GaeConfiguration conf) {
        for (Listener l : listeners) {
            l.onChange(conf);
        }
    }

    public static interface Listener {
        public void onChange(GaeConfiguration var1);
    }
}

