/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars2.rdfxml.RDFXMLParserBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserThread
extends Thread {
    private static Logger _log = Logger.getLogger(ParserThread.class.getName());
    private SAXParser _parser;
    private InputStream _in;
    private RDFXMLParserBase _rxpb;
    private Exception _e = null;
    private final BlockingQueue<Node[]> _q;

    public ParserThread(SAXParser parser, InputStream in, RDFXMLParserBase rxpb, BlockingQueue<Node[]> bq) {
        this._q = bq;
        this._parser = parser;
        this._in = in;
        this._rxpb = rxpb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._parser.parse(this._in, (DefaultHandler)this._rxpb);
        }
        catch (SAXException e) {
            _log.severe(e.getMessage());
            this._e = e;
        }
        catch (IOException e) {
            _log.severe(e.getMessage());
            this._e = e;
        }
        finally {
            try {
                this._q.put(new Node[0]);
            }
            catch (InterruptedException e) {
                _log.severe(e.getMessage());
            }
        }
    }

    public Exception getException() {
        return this._e;
    }
}

