/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicksIterator
implements Iterator<Node[]> {
    static final transient Logger DEFAULT_LOG = Logger.getLogger(TicksIterator.class.getName());
    static final String DEFAULT_MESSAGE = "Input ";
    static final Level DEFAULT_LEVEL = Level.INFO;
    final Logger _log;
    final Level _l;
    final Iterator<Node[]> _in;
    final int _ticks;
    final String _message;
    long _count = 0L;

    public TicksIterator(Iterator<Node[]> in, int ticks) {
        this(in, ticks, DEFAULT_LOG, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public TicksIterator(Iterator<Node[]> in, int ticks, Logger log) {
        this(in, ticks, log, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public TicksIterator(Iterator<Node[]> in, int ticks, Logger log, Level l) {
        this(in, ticks, log, l, DEFAULT_MESSAGE);
    }

    public TicksIterator(Iterator<Node[]> in, int ticks, Logger log, String message) {
        this(in, ticks, log, DEFAULT_LEVEL, message);
    }

    public TicksIterator(Iterator<Node[]> in, int ticks, Logger log, Level l, String message) {
        this._in = in;
        this._log = log;
        this._ticks = ticks;
        this._message = message;
        this._l = l;
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> in, int ticks) {
        return TicksIterator.createTicksIterator(in, ticks, DEFAULT_LOG, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> in, int ticks, Logger log) {
        return TicksIterator.createTicksIterator(in, ticks, log, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> in, int ticks, Logger log, Level l) {
        return TicksIterator.createTicksIterator(in, ticks, log, l, DEFAULT_MESSAGE);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> in, int ticks, Logger log, String message) {
        return TicksIterator.createTicksIterator(in, ticks, log, DEFAULT_LEVEL, message);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> in, int ticks, Logger log, Level l, String message) {
        if (ticks > 0) {
            return new TicksIterator(in, ticks, log, l, message);
        }
        return in;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    public long count() {
        return this._count;
    }

    @Override
    public Node[] next() {
        Node[] next = this._in.next();
        ++this._count;
        if (this._ticks > 0 && this._count % (long)this._ticks == 0L || !this.hasNext()) {
            this._log.log(this._l, this._message + " " + this._count);
        }
        return next;
    }

    @Override
    public void remove() {
        this._in.remove();
    }
}

