/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.util.ResetableIterator;
import org.semanticweb.yars.util.TicksIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetableFileIterator
implements ResetableIterator<Node[]> {
    protected Iterator<Node[]> iter = null;
    InputStream is = null;
    String in = null;
    boolean gz = false;
    int ticks = 0;
    Exception e = null;

    public ResetableFileIterator(String in, boolean gz) {
        this(in, gz, 0);
    }

    public ResetableFileIterator(String in, boolean gz, int ticks) {
        this.in = in;
        this.gz = gz;
        this.ticks = ticks;
        this.reset();
    }

    protected void resetFile() throws IOException {
        InputStream is = new FileInputStream(this.in);
        if (this.gz) {
            is = new GZIPInputStream(is);
        }
        this.iter = new NxParser(is);
        if (this.ticks > 0) {
            this.iter = new TicksIterator(this.iter, this.ticks);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasNext();
    }

    @Override
    public Node[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Override
    public void reset() {
        this.iter = null;
        try {
            this.resetFile();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    public Exception getException() {
        return this.e;
    }
}

