/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.xml;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.RDF;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFXMLLiteral
extends Datatype<Document> {
    public static final Resource DT = RDF.XMLLITERAL;
    private Document _d = null;
    private boolean _empty = false;

    public RDFXMLLiteral(String s) throws DatatypeParseException {
        s = s.trim();
        if (s == null) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (s.isEmpty()) {
            this._empty = true;
            return;
        }
        s = "<xmlliteral>" + s + "</xmlliteral>";
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
        try {
            DocumentBuilderFactory builderF = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderF.newDocumentBuilder();
            builder.setErrorHandler(new SuperAdvancedErrorHandler());
            this._d = builder.parse(bais);
            this._d.normalize();
        }
        catch (Exception e) {
            throw new DatatypeParseException("Error parsing DOM Document (XMLLiteral) : " + e.getMessage(), 2);
        }
    }

    @Override
    public Document getValue() {
        return this._d;
    }

    @Override
    public String getCanonicalRepresentation() {
        if (this._empty) {
            return "";
        }
        return RDFXMLLiteral.xmlToString(this._d.getFirstChild().getFirstChild()).substring("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length());
    }

    private static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws DatatypeParseException {
        RDFXMLLiteral hex = new RDFXMLLiteral("<lah>asd<br />fkg</lah>");
        System.err.println(hex.getCanonicalRepresentation());
    }

    public static class SuperAdvancedErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException arg0) throws SAXException {
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
        }

        public void warning(SAXParseException arg0) throws SAXException {
        }
    }
}

