/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.string;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDToken
extends Datatype<String> {
    public static final Resource DT = XSD.TOKEN;
    private String _ns;
    public static final String REGEX = "[^\\n\\t\\r ]?|[^\\n\\t\\r ][^\\n\\t\\r ]|[^ \\n\\t\\r][^\\n\\t\\r]*[^ \\n\\t\\r]";

    public XSDToken(String s) throws DatatypeParseException {
        if (!s.isEmpty() && !Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [^\\n\\t\\r ]?|[^\\n\\t\\r ][^\\n\\t\\r ]|[^ \\n\\t\\r][^\\n\\t\\r]*[^ \\n\\t\\r].", s, DT, 20);
        }
        if (s.contains("  ")) {
            throw new DatatypeParseException("Lexical value should not contain a double-space.", s, DT, 21);
        }
        this._ns = s;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ns;
    }

    @Override
    public String getValue() {
        return this._ns;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDToken dec = new XSDToken("a b");
        System.err.println(dec.getCanonicalRepresentation());
        System.err.println(dec.getValue());
    }
}

