/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.string;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDNormalisedString
extends Datatype<String> {
    public static final Resource DT = XSD.NORMALIZEDSTRING;
    private String _ns;
    public static final String REGEX = "[^\\t^\\r^\\n]*";

    public XSDNormalisedString(String s) throws DatatypeParseException {
        if (s == null) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [^\\t^\\r^\\n]*.", s, DT, 2);
        }
        this._ns = s;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._ns;
    }

    @Override
    public String getValue() {
        return this._ns.replace("\n", " ");
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDNormalisedString dec = new XSDNormalisedString("");
        System.err.println(dec.getCanonicalRepresentation());
        System.err.println(dec.getValue());
    }
}

