/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDLong
extends Datatype<Long> {
    public static final Resource DT = XSD.LONG;
    private long _l;
    public static final String REGEX = "[+-]?[0-9]*";

    public XSDLong(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [+-]?[0-9]*.", s, DT, 2);
        }
        try {
            this._l = !s.startsWith("+") ? Long.parseLong(s) : Long.parseLong(s.substring(1));
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Error parsing long: " + e.getMessage() + ".", s, DT, 4);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return Long.toString(this._l);
    }

    @Override
    public Long getValue() {
        return this._l;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDLong dec = new XSDLong("+9223372036854775807");
        System.err.println(dec.getCanonicalRepresentation());
    }
}

