/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Triple;

public class Quad
extends Triple
implements Serializable {
    private Node _context;
    public static final Resource CONTEXT = new Resource("http://sw.deri.org/2004/06/yars#context");
    public static final long serialVersionUID = 1L;

    public Quad(Node subject, Node predicate, Node object, Node context) {
        super(subject, predicate, object);
        this._context = context;
    }

    public Quad(Triple t, Node context) {
        super(t);
        this._context = context;
    }

    public Quad(Quad s) {
        super(s);
        this._context = s.getContext();
    }

    public static Quad fromArray(Node[] na) {
        if (na.length != 4) {
            return null;
        }
        return new Quad(na[0], na[1], na[2], na[3]);
    }

    public Node[] toArray() {
        Node[] n = new Node[]{this.getSubject(), this.getPredicate(), this.getObject(), this.getContext()};
        return n;
    }

    public Node getContext() {
        return this._context;
    }

    public void setContext(Resource context) {
        this._context = context;
    }

    public String toString() {
        return this.toN3();
    }

    public String toN3() {
        if (this._context == null) {
            return super.toN3();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this._sub.toN3());
        buf.append(" ");
        buf.append(this._pred.toN3());
        buf.append(" ");
        buf.append(this._obj.toN3());
        buf.append(" ");
        buf.append(this._context.toN3());
        buf.append(" ");
        buf.append(".");
        return buf.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o != null && o instanceof Quad;
        if (result) {
            Quad s = (Quad)o;
            result &= s._sub.equals(this._sub) && s._pred.equals(this._pred) && s._obj.equals(this._obj) && s._context.equals(this._context);
        }
        return result;
    }

    public int hashCode() {
        return this.toN3().hashCode();
    }
}

