/*
 * Decompiled with CFR 0.152.
 */
package de.xam.kgif.impl.itemset;

import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.util.KgifNIO;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.KgifValidationJob;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.ioutils.YEntityHandler;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReads;
import com.calpano.kgif.v1_1_0.read.ValidatingEntityHandler;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.cmodel.fact.impl.ChangeDataImpl;
import de.xam.itemset.IItemSet;
import de.xam.kgif.impl.itemset.KgifEntityHandler;
import java.io.IOException;

public class KgifItemset {
    public static void readKgif(IStreamSource source, IItemSet itemSet, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException {
        KgifEntityHandler keh = new KgifEntityHandler(itemSet);
        KgifItemset.readKgif(source, keh, progress);
    }

    public static void readKgif(IStreamSource source, IEntityHandler entityHandler, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException {
        KgifValidationJob job = new KgifValidationJob();
        job.setRequireNodeLabels(false);
        job.setRequireUseOnlyIdsWithEntities(true);
        ValidatingEntityHandler veh = new ValidatingEntityHandler(job);
        veh.setThrowExceptions(true);
        YEntityHandler yeh = new YEntityHandler((IEntityHandler)veh, entityHandler);
        KgifNIO.readKgif1_1_0((IStreamSource)source, (IEntityHandler)yeh, (IStreamProcessProgressReporter)progress);
    }

    public static IChangeData toChangeData(Metadata metadata) {
        IChangeData changeData;
        IChangeData changeDataDefaults = ChangeDatas.createWithCreationDate_Now((String)"readKgif", (String)"KgifMapper.onNode");
        if (metadata == null) {
            changeData = changeDataDefaults;
        } else {
            long creationDate;
            String lastModifiedStr = KgifReads.getAttributeValue((Metadata)metadata, (String)VocabularyCModel.ATTRIBUTE_LAST_MODIFIED.toString(), (String)(changeDataDefaults.getLastModifiedUTC() + ""));
            String creationSource = KgifReads.getAttributeValue((Metadata)metadata, (String)VocabularyCModel.ATTRIBUTE_CREATION_SOURCE.toString(), (String)changeDataDefaults.getCreationSource());
            String creationDateStr = KgifReads.getAttributeValue((Metadata)metadata, (String)VocabularyCModel.ATTRIBUTE_CREATION_DATE.toString(), (String)(changeDataDefaults.getCreationDateUTC() + ""));
            String createdBy = KgifReads.getAttributeValue((Metadata)metadata, (String)VocabularyCModel.ATTRIBUTE_CREATED_BY.toString(), (String)changeDataDefaults.getCreatedBy());
            ChangeDataImpl changeDataDefined = new ChangeDataImpl(createdBy, creationSource);
            long lastModified = Long.parseLong(lastModifiedStr);
            if (lastModified > 0L) {
                changeDataDefined.setLastModifiedUTC(lastModified);
            }
            if ((creationDate = Long.parseLong(creationDateStr)) > 0L) {
                changeDataDefined.setCreationDateUTC(creationDate);
            }
            changeData = changeDataDefined;
        }
        return changeData;
    }
}

